#!/usr/bin/perl -w

#========================================================================
#========================================================================

use strict;
use warnings;

use FindBin qw($Bin $Script);
#use lib "$FindBin::Bin/lib";

use Getopt::Long;
my $VERSION = "0.1.0";
my %opts = ();

GetOptions(\%opts, 'output=s', 'revcom', 'help') or &usage(2, $!);
# check options
&usage(2, "Show the help message\n") if (exists $opts{help});
&usage(1, "Input was not accepted, use '-help' to get more message\n")  if (@ARGV != 2);

my ($site, $file) = @ARGV;
my ($head, $seq, $len);
open (IN, "$file") or die "[err] failed to open $file\n";
$/ = "\n>";
while (<IN>) {
	chomp;
	s/^>//g;
	($head, $seq) = split(/\n+/, $_, 2);
	$seq = uc $seq;
	$seq =~ s/\s+//g;
	$len = length $seq;
	last;
}
$/ = "\n";

if (exists $opts{revcom}) {
	$seq = substr($seq, $site) . substr($seq, 0, $site);
	$seq =~ tr/ATGCN/TACGN/;
	$seq = reverse $seq;
} else {
	$seq = substr($seq, $site-1) . substr($seq, 0, $site-1);
}

die sprintf ("[error] sequence length error: $len != %d\n", length $seq) if (length $seq != $len);
$seq =~ s/(\w{60})/$1\n/g;
$seq =~ s/\n$//g;
open (STDOUT, ">$opts{output}") or die $! if (exists $opts{output});
print ">$head\n$seq\n";




sub usage {
    my $flag = shift;
    print qq(@_
    PROGRAM
        $Script  -  $VERSION
    USAGE
        perl $0 [-output out_seq.fsa] [-revcom] <origin_site>  <sequence.fsa>
    ARGUMENTS
        <origin_site>    input change origin site information
        <sequence.fa>    input sequence by fasta format
    OPTIONS
        -output <STR>    output file to instead of [STDOUT]
        -revcom          reverse complement sequence
    DESCRIPTION
        This script using for changing the start site of a sequence in a FASTA file.

    \n);
    exit;
}
